# func for reverse mapping name into gn (see techinit.mm file )

func altera_fix_eddm_name (string cellname) {


      switch ( (upper @cellname)) {

            BUF.3SO { cellname = TRI }
            "74LS642.1" { cellname = "74LS642_1" }
            () { break }
      }
 return (upper @cellname )
}

#Hierarchial edif reader

func wr_edifcell (abstract netlist nl; string foo) {
    abstract cell cell
    abstract view v instof
    abstract instance i p
    abstract net n
    abstract connection c
    string dir field instname viewname cellname libname netname portname
    list prop tmpparms tmpprops
    untyped data u rise fall
    string s ds pd1 pd2 pd3

    ds =\
    "\n              (portDelay (derivation CALCULATED)(delay %s)(transition %s))"
    pd1 =\
    "\n              (portDelay (derivation REQUIRED)(userData TIMINGID \"MIF\")"       
    pd2 = "\n                (loadDelay tpHL tmulLH)(transition L H))"
    pd3 = "\n                (loadDelay tpHL tmulHL)(transition H L))"

    v = @nl._view
    cell = @v._cell
    u = @cell

    if @Verbose (printf "  cell %s (%d ports, %d insts, %d nets)\n" \
        (eval @CellNameEval) @nl._numports @nl._numinsts @nl._numnets)

    fprintf @EdifFp "    (cell %s\n" (edifname (eval @CellNameEval))
    fprintf @EdifFp "      (cellType GENERIC)\n"
    u = @v
    fprintf @EdifFp "      (view %s\n" (edifname (eval @ViewNameEval))
    fprintf @EdifFp "        (viewType NETLIST)\n"
    fprintf @EdifFp "        (interface\n"

    if (@v.lsim_parameters) {
	/* hack for lsim */
	untyped parm

	fprintf @EdifFp "          (property ELEMENT (string \"%s\"))" \
						@v.lsim_parameters[0]
	if ((listlen @v.lsim_parameters) > 1) {
	    print_lsim_parmdef @v
	}
    }
    foreach p (ports @nl) {
	switch @p._portdir {
	    case "I" (dir = input)
	    case "O" (dir = output)
	    () (dir = inout)
	}
	u = @p
	fprintf @EdifFp "          (port %s (direction %s)" \
	    (edifname (eval @PortNameEval)) @dir
	foreach prop @PortProps {
	    data = (eval @prop[1])
	    if (isnull @data) (continue)
	    fprintf @EdifFp "\n            (property %s %s)" \
		@prop[0] (ediftypedval @data)
	}
	fprintf @EdifFp ")\n"
    }
    fprintf @EdifFp "        )\n"

    if (@foo == contents) {
        fprintf @EdifFp "        (contents\n"
        foreach i (instances @nl) {
            instof = @i._instof
            u = @i
            instname = (edifname (eval @InstNameEval))
            u = @instof
            viewname = (edifify (eval @ViewNameEval))
            u = @instof._cell
            cellname = (edifify (eval @CellNameEval))
            if (@instof._external) {
                libname = @PrimLib
		/*
		 * hack for writing zcad edif
		 */
		if @u.ediflib (libname = @u.ediflib)
            } {
                libname = @UserLib
            }
            fprintf @EdifFp "          (instance %s\n" @instname
            fprintf @EdifFp "            (viewRef %s " @viewname
            fprintf @EdifFp "(cellRef %s " @cellname
            if( ( @libname == @UserLib) &&  (!@instof._external)) {
                 fprintf @EdifFp "))"
            } else { 
	       if (@libname != @nl._view._cell._library._name) {
                   fprintf @EdifFp "(libraryRef %s)))" (edifify @libname)
	       }{
                fprintf @EdifFp "))"
	       }
            }
            u = @i
	    /*
	     * evaluate InstParms if needed
	     */
	    if (@InstParms && ((typestring @InstParms[0]) == string)) {
		tmpparms = (eval @InstParms)
	    } else {
		tmpparms = @InstParms
	    }

	    /*
	     * process the assoc list of parameters
	     */
            foreach prop @tmpparms {
                data = (eval @prop[1])
                if (isnull @data) (continue)
                fprintf @EdifFp "\n            "
		/*
		 * hack - see if the string has double quotes imbedded
		 * around it.  When does this happen?
		 */
                if (((typestring @data) == string) && \
		    (substr @data 0 1) == "\"") {
                    fprintf @EdifFp "(parameterAssign %s (string %s))" \
                        (edifify @prop[0]) @data
                }{
                    fprintf @EdifFp "(parameterAssign %s %s)" \
                        (edifify @prop[0]) (ediftypedval @data)
                }
            }

	    /*
	     * evaluate InstProps if needed
	     */
	    if (@InstProps && ((typestring @InstProps[0]) == string)) {
		tmpprops = (eval @InstProps)
	    } else {
		tmpprops = @InstProps
	    }

	    /*
	     * process the assoc list of properties
	     */
            foreach prop @tmpprops {
                data = (eval @prop[1])
                if (isnull @data) (continue)
                fprintf @EdifFp "\n            (property %s %s)" \
                    @prop[0] (ediftypedval @data)
            }
            foreach c (connections @i) {
                u = @c
                rise = (eval @PortRiseDelay)
                fall = (eval @PortFallDelay)
                if ((isnull @rise) && (isnull @fall))(continue)
                u = @c._port
                if (@Bus && @u.bus) {
                    fprintf @EdifFp \
			"\n            (portInstance (member %s %d)" \
                        (edifify @u.bus[0]) @u.bus[1]
                } else {
                    fprintf @EdifFp "\n            (portInstance %s" \
                    (edifify (eval @PortNameEval))
                }
                if (isnotnull @rise) {
                    fprintf @EdifFp @ds (edifnumber @rise) "L H"
                }
                if (isnotnull @fall) {
                    fprintf @EdifFp @ds (edifnumber @fall) "H L"
                }
                fprintf @EdifFp ")" 
            }
            fprintf @EdifFp ")\n" 
        }
        foreach n (nets @nl) {
            u = @n
            netname = (edifname (eval @NetNameEval))
            fprintf @EdifFp "          (net %s\n" @netname
            fprintf @EdifFp "            (joined " 
            foreach c (connections @n) {
                if (@c._port) {
                   u = @c._instance
                   instname = (edifify (eval @InstNameEval))
                   u = @c._port
                   if (@Bus && @u.bus) {
                      portname = (cat "(member " (edifify @u.bus[0]) " " \
		      @u.bus[1] ")")
                   } else {
                      portname = (edifify (eval @PortNameEval))
                   }
                   fprintf @EdifFp "\n              "
                   fprintf @EdifFp "(portRef %s " @portname
                   fprintf @EdifFp "(instanceRef %s))" @instname
                } else {
                   u = @c._instance
                   portname = (edifify (eval @PortNameEval))
                   fprintf @EdifFp "\n              "
                   fprintf @EdifFp "(portRef %s)" @portname
                }
            }
            fprintf @EdifFp ")"
            u = @n
	    /*
	     */
	    if (@NetProps && ((typestring @NetProps[0]) == string)) {
		tmpprops = (eval @NetProps)
	    } else {
		tmpprops = @NetProps
	    }

	    /*
	     * process the assoc list of properties
	     */
            foreach prop @tmpprops {
                data = (eval @prop[1])
                if (isnull @data) (continue)
                fprintf @EdifFp "\n            (property %s %s)" \
                    @prop[0] (ediftypedval @data)
            }
            fprintf @EdifFp ")\n" 
        }
        fprintf @EdifFp "        )\n"
        u = @v
	/*
	 * evaluate ViewProps if needed
	 */
	if (@ViewProps && ((typestring @ViewProps[0]) == string)) {
	    tmpprops = (eval @ViewProps)
	} else {
	    tmpprops = @ViewProps
	}

	/*
	 * process the assoc list of properties
	 */
        foreach prop @tmpprops {
            data = (eval @prop[1])
            if (isnull @data) (continue)
            fprintf @EdifFp "        (property %s %s)\n" @prop[0] \
                (ediftypedval @data)
        }
    }
    fprintf @EdifFp "      )\n"
    u = @cell
    /*
     * evaluate CellProps if needed
     */
    if (@CellProps && ((typestring @CellProps[0]) == string)) {
	tmpprops = (eval @CellProps)
    } else {
	tmpprops = @CellProps
    }

    /*
     * process the assoc list of properties
     */
    foreach prop @tmpprops {
        data = (eval @prop[1])
        if (isnull @data) (continue)
        fprintf @EdifFp "      (property %s %s)\n" @prop[0] \
            (ediftypedval @data)
    }
    fprintf @EdifFp "    )\n"
}

#patch for Np mapping into genlib components DR: 65203 /51812
# Fixed in np patch49/np patch 82/ train1. will remove it in the next release.

func np_gen2gfl(global abstract netlist Nl) {
	global abstract library GenLib GflLib
	global abstract net np1 np2 np3 np4
	global abstract instance Aip
	global string iname
	global list conns
	global abstract view GflInv GflBuf GflAnd2 GflAnd3
	global abstract view GflXor2 GflXor3 GflOr2
	global abstract view GflDffrs GflLatrs GflMux GflTri
	global abstract view GflTrue GflFalse
	global list Iprops
	global list Xfers # list of xfer gates

	abstract instance ip p
	abstract connection c
	abstract view v gv
	abstract cell cellp
	string gflname
	int nc

	gfl_initlib
	np_gen_lib
	GflLib   = (findlibrary GFL_LIB)
	GenLib   = (findlibrary gen_lib)
	GflInv   = (findview (findcell @GflLib INV)   INTERFACE)
	GflBuf   = (findview (findcell @GflLib BUF)   INTERFACE)
	GflAnd2  = (findview (findcell @GflLib AND2)  INTERFACE)
	GflAnd3  = (findview (findcell @GflLib AND3)  INTERFACE)
	GflXor2  = (findview (findcell @GflLib XOR2)  INTERFACE)
	GflXor3  = (findview (findcell @GflLib XOR3)  INTERFACE)
	GflOr2   = (findview (findcell @GflLib OR2)   INTERFACE)
	GflDffrs = (findview (findcell @GflLib DFFRS) INTERFACE)
	GflLatrs = (findview (findcell @GflLib LATRS) INTERFACE)
	GflMux   = (findview (findcell @GflLib MUX)   INTERFACE)
	GflTri   = (findview (findcell @GflLib TRI)   INTERFACE)
	GflTrue  = (findview (findcell @GflLib TRUE)  INTERFACE)
	GflFalse = (findview (findcell @GflLib FALSE) INTERFACE)

	Xfers = '()
	list insts
        insts = '()
	foreach ip (instances @Nl) {
	    prepend insts @ip
	}
	foreach ip @insts {
		v = @ip._instof
		cellp = @v._cell
		if(@cellp._library != @GenLib) (continue)
		gflname = @v.gflname
		if @gflname {
			nc = @ip._numconns
			if @v.ngate {
				gflname = (cat @gflname (@nc - 1))
			}
			gv = (findview (findcell @GflLib @gflname) INTERFACE)
			conns = '()
			foreach p (ports @gv._netlist) {
				prepend conns (bld @p._name @p.pos)
			}
			sortlist conns gt 1
			foreach p (ports @v._netlist) {
			       conns[@p.pos][1] = (findconn @ip @p._name) . _net
			}
			iname = @ip._name
			Iprops <- @ip._proplist
			deleteabs @ip
			ip = (addinstance @Nl @gv @conns)
			if @Iprops { # copy properties
				untyped p pn
				foreach p @Iprops {
					pn = @p[0]
					ip.@pn <- @p[1]
				}
			}
			{
				ip._name = @iname
			Error:
			}
			continue
		}
		iname = @cellp._name
		gflname = (cat np_gen2gfl_ @iname)
		if(!(isfuncdef @gflname)) {
			error "Missing conversion function for"  @iname
		}
		conns = '()
		foreach c (connections @ip) {
			prepend conns (bld @c._portname @c._net)
		}
		iname = @ip._name
		Iprops <- @ip._proplist
		deleteabs @ip
		callfunc @gflname
	}
	if @Xfers (np_gen2gfl_fix_xfers @Xfers)
	# np_gen2gfl_fixtf @Nl
	deletejoingates @Nl
}

# patch for Np mapping into genlib component JKFF
# will be fixed in Train1 
# DR 81246, commited to fix in train1

func np_gen_lib(args libname) {
	global abstract library GenLib
	int i
	abstract instance p
	abstract cell cellp
	abstract view v
	abstract netlist gnl

	if(isnull @libname) (libname = gen_lib)
	GenLib = (catch () findlibrary @libname)
	if @GenLib (return)
	GenLib = (addlibrary external @libname)
	for(i = 0; @i <= 9; ++i) (np_gen_telegates @i)
	np_gen_telegates 12
	np_gen_telegates 16
	np_gen_lib_ngate xor XOR "" 2
	np_gen_lib_ngate xnor XNOR "" 2
	for(i = 3; @i < 9; ++i) {
		np_gen_lib_ngate pgen XOR ".o" @i
		np_gen_lib_ngate pgen XNOR ".e" @i
	}
	np_gen_lib_fgate buf BUF OUT I0
	np_gen_lib_fgate delay BUF OUT IN
	np_gen_lib_fgate inv INV OUT IN
	gnl = (np_gen_lib_fgate buf.3so TRI OUT IN EN)
	p = (findport @gnl OUT); p.drv = TRISTATE
	gnl = (np_gen_lib_fgate inv.3so () OUT IN EN)
	p = (findport @gnl OUT); p.drv = TRISTATE
	np_gen_lib_fgate dec12 () OUT0 OUT1 I0
	np_gen_lib_fgate dec24 () OUT0 OUT1 OUT2 OUT3 I0 I1
	np_gen_lib_fgate dec38 () OUT0 OUT1 OUT2 OUT3 OUT4 OUT5 OUT6 OUT7 I0 I1 I2
	np_gen_lib_fgate mux21 MUX OUT I0 I1 S0
	np_gen_lib_fgate mux41 () OUT I0 I1 I2 I3 S0 S1
	np_gen_lib_fgate fa () S CO CI I0 I1
	np_gen_lib_fgate ha () S CO I0 I1
	np_gen_lib_fgate ground FALSE SPACE
	np_gen_lib_fgate vee FALSE SPACE
	np_gen_lib_fgate vcc TRUE SPACE
	np_gen_lib_fgate forcex IMASK OUT IN FORCEX
	np_gen_lib_fgate reg DFFRS O I0 EN CLR SET
	np_gen_lib_fgate dff () Q QB D CLK CLR PRE
	np_gen_lib_fgate jkff () Q QB J K CLK CLR PRE
# I believe that this is a typo and was intended to be "jkff".  Rather than
# risk breaking something, I'll create jkff in addition to this and leave
# jkdff alone.
	np_gen_lib_fgate jkdff () Q QB J K CLK CLR PRE
	np_gen_lib_fgate latch LATRS O I0 EN CLR SET
	np_gen_lib_fgate netcon () OUT IN
	gnl = (np_gen_lib_fgate xfer () OUT E0 I0)
	p = (findport @gnl OUT); p.drv = TRISTATE
	foreach cellp (cells @GenLib) {
		v = (findview @cellp INTERFACE)
		v.syn_eddm_path = (cat "$MGC_GENLIB/" @cellp._name)
	}
}

func np_gen2gfl_jkff () { # Q QB J K CLK CLR PRE
	np1 = (addnet @Nl)
	np2 = (addnet @Nl)
        np3 = (addnet @Nl)
        np4 = (addnet @Nl)
        np_gen2gfl_i @GflInv ".ci" (bld (bld out @np3) \
            (bld in @conns.CLR))
        np_gen2gfl_i @GflInv ".si" (bld (bld out @np4) \
            (bld in @conns.PRE))
	np_gen2gfl_i @GflInv ".k" (bld (bld out @np1) (bld in @conns.K))
	np_gen2gfl_i @GflMux ".m" (bld (bld out @np2) (bld in0 @conns.J) \
	    (bld in1 @np1) (bld sel @conns.Q))
	np_gen2gfl_i @GflDffrs "" (bld (bld out @conns.Q) (bld in @np2) \
	    (bld set @np4) (bld reset @np3) (bld clk @conns.CLK))
	np_gen2gfl_i @GflInv ".qb" (bld (bld out @conns.QB) \
	    (bld in @conns.Q))
}

# Changing the Header from SCS to Mentor Graphics Corp
# DR 84539

func wr_edifheader {
    fprintf @EdifFp "(edif netlist\n"
    fprintf @EdifFp "  (edifVersion 2 0 0)\n"
    fprintf @EdifFp "  (edifLevel 0)\n"
    fprintf @EdifFp "  (keywordMap (keywordLevel 0))\n"
    fprintf @EdifFp "  (status\n"
    fprintf @EdifFp "    (written\n"
    fprintf @EdifFp "      (timeStamp %s)\n" (ediftimestamp)
    fprintf @EdifFp "      (author \"Mentor Graphics Corporation\")\n"
    fprintf @EdifFp "      (program \"Netlist Processor (ALTERA Autologic Library)\")\n"
    fprintf @EdifFp "    )\n"
    fprintf @EdifFp "  )\n"
    if @UserHook1 {
        fprintf @EdifFp "%s" (eval @UserHook1)
    }
} 

# suppressing the printlns in the function 
#DR 84538
func wr_edif( string fname ; abstract netlist nl ) { args options
    /*
     * Warning:  THIS FUNCTION IS NOT SIMPLE TO USE.  ARBITRARY NETLISTS
     *           CAN BE COMPLICATED.   EDIF IS COMPLICATED.   TRANSLATING
     *           AN ARBITRARY NETLIST INTO EDIF HAS TO BE COMPLICATED OR
     *           IT CAN'T WORK.
     *
     * Suggestion: If you find this function too convoluted to  use or
     *		   unable to produce a particular vendor-specific flavor
     *		   of EDIF, consider having a CAD developer write a custom
     *		   EDIF writer (using Np) for your application.  For many
     *		   applications, the custom writer functions will total
     *		   less than 500 lines. EDIF constructs such as parameters,
     *		   arrays, bundles, delays, etc may significantly increase
     *		   the complexity of the functions.  Your custom functions
     *		   will probably need only support a small subset of EDIF
     *		   constructs.  No single EDIF writer function will likely be 
     *		   sufficient for everybody's needs.
     *
     * Write an netlist in EDIF 2 0 0 (subset) format.
     *
     * Usage:
     *   wr_edif <outfile.s> <netlist.h> '(assoc list of options)
     *
     * Example:
     *
     *   wr_edif outf.edif @Netlist '{
     *      cell (@u.gatetype)
     *      instanceprops ((NUMINPUTS (@u._numconns - 1))(STRENGTH 3))
     *      portrisedelay (@u.rise * 100)
     *      portfalldelay (@u.fall * 100)
     *      userlib USERLIB
     *      primlib PRIMLIB
     *   }
     *
     * Options:
     *     cell <name.l>            # default is '(@u._name)
     *     view <name.l>            # default is '(@u._name)
     *     instance <name.l>        # default is '(@u._name)
     *     port <name.l>            # default is '(@u._name)
     *     net <name.l>             # default is '(@u._name)
     *     cellprops <props.l>      # default is '()
     *     viewprops <props.l>      # default is '()
     *     instprops <props.l>      # default is '()
     *     portprops <props.l>      # default is '()    
     *     netprops <props.l>       # default is '()
     *     userlib <name.s>         # default is USERLIB
     *     primlib <name.s>         # default is PRIMLIB
     *     instparms <props.l>      # default is '()
     *     portrisedelay <delay.l>  # default is '()
     *     portfalldelay <delay.l>  # default is '()
     *     noexternlib <val.i>      # default is 0
     *     verbose <vali.i>         # default is 0
     *     bus <val.i>              # default is 0
     *     edififyoptions "e"|"l"   # default is NIL
     *     userhook1 <misc.s>       # default is NIL
     *     
     *
     *   <name.l> is a list of genie commands which, when evaluated,
     *     returns a name for the current object. "u" is a handle
     *     to the current object.
     *
     *   <props.l> is an association list of interesting properties
     *     for the given object type.  Each entry in the assoc list
     *     is of the form '(<edifname.s> <eval.l>) .   <edifname.s>
     *     is the name of the field as it should appear in the
     *     EDIF property statement.  <eval.l> is a list of genie commands
     *     which, when evaluated, returns the value of the desired
     *     property for the given object.   "u" is a handle to the 
     *     current object.  If <eval.l> evaluates to a non-NULL value
     *     it will be written to the edif file.
     *     
     *   <delay.l> is a list of genie commands which, when evaluated,
     *     returns the specified delay of the current instance
     *     connection.  "u" is a handle to the current instance 
     *     connection.   If <delay.l> evaluates to NULL,
     *     no portDelay will be written for the current instance port.
     *     "u" is a handle to the current instance port.
     *
     * Although Np can probably read in the netlist generated by this
     * function (assuming properties, parameters, and portdelays are not
     * used),  the netlist read back in may have somewhat 
     * different names for objects.  The connectivity and hierarchy
     * will be preserved however.
     *
     * Because EDIF does not permit libraries to have properties,
     * there is no "libraryprops" option.
     *
     * Because this function does not write out the actual library
     * names referenced by Np, there is no "library" option.  
     *
     * The userlib and primlib options do not refer to libraries within
     * Np; rather, they refer to the library names which will be written 
     * out to the EDIF file when referencing libraries.  All non-primitive
     * instances will reference cells in userlib, and all primitive
     * instances will reference cells in primlib. 
     *
     * This function assumes that all primitive cells are defined 
     * in a single technology library.  If this is not the case,
     * a name collision may occur because all primitive cells will be
     * written to a single output external library.
     *
     * The (noexternlib 0) option will supress the generation of the
     * external library.
     *
     * This function assumes that all non-primitive cells are defined
     * in a single library.  If this is not the case, a name collision
     * may occur because all non-primitive cells will be written
     * to a single output library.
     *
     * This function assumes that that only a single view of any given
     * cell (primitive and user-defined) is used.
     *
     * Yet to be implemented:
     *
     *    EDIF parameters (instance parameters already done)
     *    EDIF arrays
     *    abitrary EDIF constructs
     */

    global file EdifFp
    global string UserLib PrimLib
    global list PrimList CellList 
    global untyped InstParms CellProps ViewProps InstProps NetProps PortProps
    global list PortRiseDelay PortFallDelay
    global list CellNameEval ViewNameEval InstNameEval 
    global list PortNameEval NetNameEval
    global int Errs 
    global untyped NoExternLib Verbose Bus EdififyOpts UserHook1
    global untyped DistanceScale TimeScale NoRecurse
    untyped u

 #suppressing printfs
   # printf "Writing EDIF file %s ...\n" @fname  

    Errs = 0

    if @options {
        CellNameEval = @options.cell
        ViewNameEval = @options.view
        InstNameEval = @options.instance
        PortNameEval = @options.port
        NetNameEval = @options.net
        NetProps = @options.netprops
        InstProps = @options.instanceprops
        ViewProps = @options.viewprops
        CellProps = @options.cellprops
        PortProps = @options.portprops
        UserLib = @options.userlib
        PrimLib = @options.primlib
        InstParms = @options.instparms
        PortRiseDelay = @options.portrisedelay
        PortFallDelay = @options.portfalldelay
        NoExternLib = @options.noexternlib
        Verbose = @options.verbose
        Bus = @options.bus
	EdififyOpts = @options.edififyoptions
	UserHook1 = @options.userhook1
	DistanceScale = @options.distancescale
	TimeScale = @options.timescale
	NoRecurse = @options.norecurse
    }
    if (! @PortNameEval) (PortNameEval = '(@u._name))
    if (! @CellNameEval) (CellNameEval = '(@u._name))
    if (! @ViewNameEval) (ViewNameEval = '(@u._name))
    if (! @InstNameEval) (InstNameEval = '(@u._name))
    if (! @NetNameEval) (NetNameEval = '(@u._name))
    if (! @NetProps) (NetProps = '())
    if (! @InstProps) (InstProps = '())
    if (! @ViewProps) (ViewProps = '())
    if (! @CellProps) (CellProps = '())
    if (! @PortProps) (PortProps = '())
    if (! @UserLib) (UserLib = USERLIB)
    if (! @PrimLib) (PrimLib = PRIMLIB)
    if (! @InstParms) (InstParms = '())
    if (! @PortRiseDelay) (PortRiseDelay = '())
    if (! @PortFallDelay) (PortFallDelay = '())

    if @EdififyOpts {
	edififyoptions @EdififyOpts
    } else {
	/* clear out any old options */
	edififyoptions ""
    }

    EdifFp = (fopen @fname "w")
    if (! @EdifFp) (error Cant create @fname)

    wr_edifheader

    /*
     * find the technology library and write it out.   We could
     * simply go to the tech lib and write out all the cells we
     * find, but some of the cells might not be used in our design.
     * Instead, we'll have to walk the hierarchy.  All leaf cells
     * we encounter will be written to @PrimLib.  This also insures
     * that cell will be defined before they are referenced.
     */
    if (! @NoExternLib) {
	wr_ediflibraryheader external @PrimLib
        PrimList = '()
        wr_edifprimcells @nl
        wr_ediflibrarytail
    }

    /*
     * write the non-primitive cells.   We'll walk the hierarchy
     * and write out cells bottom up to insure that they are defined
     * before referenced.  All non-primitive cells encountered
     * will be written to UserLib
     */
    wr_ediflibraryheader library @UserLib
    CellList = '()
    wr_edifusercells @nl
    wr_edifcell @nl contents
    wr_ediflibrarytail

    /*
     * write out the design record 
     */
    u = @nl._view._cell
    fprintf @EdifFp "  (design %s (cellRef %s (libraryRef %s)))\n" \
        (edifify (eval @CellNameEval)) \
        (edifify (eval @CellNameEval)) (edifify @UserLib)
    wr_ediftail
    if (fclose @EdifFp) (error Error writing file @fname)
    if @Errs {
        printf "%d errors writing EDIF file\n" @Errs
    }
    return @Errs
}

